const   dba                                 =   require("../models/dba");
const   axios                               =   require('axios');
const   mailer                              =   require('../models/mailer');
const   jsonData                            =   require('../models/jsonData');

const   googleRecaptchaKey                  =   '6Leo_YsqAAAAALN5vWcgWVtcIo1TCQT1ON6dZf5S';
const   googleRecaptchaSecret               =   '6Leo_YsqAAAAANRpmvTByLUpU4AgL9tF_LkDfxyq';
const   websiteCompany                      =   'africangolden';
const   titleKeywordsToRemove               =   ['national','park','mountain','mount','lake','conservation','area','packages','',websiteCompany,'trekking','island','circuit'];
const   titleKeywordsToCheck                =   ['zanzibar','serengeti','ngorongoro','manyara','tarangire','mikumi','ruaha','nyerere','kilimanjaro','dar es salaam','honeymoon','uganda','kenya','wildebeest migration','Ol Doinyo Lengai','northern','southern','arusha','natron','saadani','kilwa','beach'];
        //
var     websiteLinks                        =   {
                                                    ""                      :   "Home",
                                                    "about"                 :   "About us",
                                                    "destinations"          :   [],
                                                    "packages"              :   [],
                                                    "gallery"               :   "Gallery",
                                                    "blog"                  :   "Blog",
                                                    "contact"               :   "Contact us"
                                                };

const   menuLinksWithSublinks               =   [
                                                    {"title":"packages",            "root":"/packages/"},
                                                    {"title":"destinations",        "root":"/destination/"}
                                                ];

const   websiteDataCondition                =   'SELECT * FROM scontent WHERE (ctype=? OR ctype=? OR ctype=? OR ctype=? OR ctype=? OR ctype=? OR ctype=? OR ctype=? OR ctype=? OR ctype=? OR ctype=? OR ctype=? OR (ctype=? AND ccategory!=?)) AND company_id=? ORDER BY cid DESC LIMIT 50000';
const   websiteDataParameters               =   ['about','contacts','testimonial','slides','pictures','videos','events','destinations','itineraries','articles','materials','team','categories','categories',websiteCompany];

const   websitePostsCondition               =   'SELECT * FROM scontent WHERE (ctype=? OR ctype=? OR ctype=? OR ctype=? OR ctype=? OR ctype=? OR ctype=?) AND company_id=?';
const   websitePostsParameters              =   ['slides','pictures','videos','events','itineraries','articles','materials',websiteCompany];

const   websiteGalleryCondition             =   'SELECT * FROM scontent WHERE ((ctype=? AND ccategory NOT LIKE ?) OR ctype=? OR ctype=? OR ctype=? OR ctype=? OR ctype=? OR ctype=?) AND cfiles!=? AND company_id=?';
const   websiteGalleryParameters            =   ['pictures','%breadcumb','videos','events','destinations','itineraries','articles','materials','none',websiteCompany];
        //

const   prepareDefaultWebsiteData           =   ()=>{
                                                    //
                                                    const   websiteDataPromise  =   new Promise((resolve,reject)=>{
                                                                                        //
                                                                                        const   allWebsiteDataPromise   =   dba.getDataPrepared(websiteDataCondition,websiteDataParameters);
                                                                                                allWebsiteDataPromise.
                                                                                                then(
                                                                                                    (data)=>{
                                                                            
                                                                                                        //
                                                                                                        const   allSiteDataRows                 =   data[0];
                                                                                                        var     formatedWebsiteData             =   FilterWebsiteData(allSiteDataRows);

                                                                                                        const   mostViewedWebsiteCondition      =   websitePostsCondition+' ORDER BY cid DESC LIMIT 50000';
                                                                                                        const   mostViewedWebsitePostsPromise   =   dba.getDataPrepared(mostViewedWebsiteCondition,websitePostsParameters);
                                                                                                                //
                                                                                                                mostViewedWebsitePostsPromise.
                                                                                                                then((data)=>{
                                                                                                                    //
                                                                                                                    const   mostViewedWebsitePosts          =   data[0];
                                                                                                                            formatedWebsiteData.most_viewed =   mostViewedWebsitePosts;

                                                                                                                            //
                                                                                                                            formatedWebsiteData.reviews     =   jsonData.reviews();
                                                                                                                            
                                                                                                                    resolve(formatedWebsiteData);
                                                                                                                }).
                                                                                                                catch((error)=>{
                                                                                                                    //
                                                                                                                    resolve(formatedWebsiteData);
                                                                                                                });
                                                                                                    }
                                                                                                ).
                                                                                                catch(  (error)=>{   reject("unknown data error - V1");  });
                                                                                    });

                                                            return websiteDataPromise;
                                                    
                                                }
                                                
const   GetWebsiteData                      =   ()=>{   return prepareDefaultWebsiteData(); };

const   GetWebsitePost                      =   (postId)=>{
                                                    const   dataPromise =   new Promise((resolve,reject)=>{
                                                                                    //
                                                                                    // fiirst get all site data

                                                                                    const   formatedWebsiteDataPromise  =   prepareDefaultWebsiteData();
                                                                                            formatedWebsiteDataPromise.
                                                                                            then(
                                                                                                (data)=>{
                                                                        
                                                                                                    //
                                                                                                    var     formatedWebsiteData         =   data;
                                                                                                            formatedWebsiteData.post    =   "none";
                                                                                                            formatedWebsiteData.posts   =   new Array();

                                                                                                    var     postCondition               =   'SELECT * FROM scontent WHERE IF(EXISTS(SELECT * FROM scontent WHERE ctitle=?),ctitle=?,ctitle LIKE ?) AND company_id=? ORDER BY cid DESC LIMIT 1'
                                                                                                    var     postParameters              =   [postId,postId,'%'+postId+'%',websiteCompany];
                                                                                                            if(postId.match(/^([0-9]+)$/)){
                                                                                                                postCondition           =   'SELECT * FROM scontent WHERE cid=? AND company_id=? ORDER BY cid DESC LIMIT 1'
                                                                                                                postParameters          =   [postId,websiteCompany]; 
                                                                                                            }

                                                                                                            const   postDataPromise     =   dba.getDataPrepared(postCondition,postParameters);
                                                                                                                    postDataPromise.
                                                                                                                    then((data)=>{

                                                                                                                        const postDatas  =   data[0];
                                                                                                                                if(postDatas.length>0){
                                                                                                                                    const   postData        =   postDatas[0];
                                                                                                                                    const   postUniqueId    =   postData.cid;
                                                                                                                                    const   postType        =   postData.ctype;
                                                                                                                                    const   postCategory    =   postData.ccategory;

                                                                                                                                    // update post views
                                                                                                                                    updatePostViews(postUniqueId);
                                                                                                                                    
                                                                                                                                    //
                                                                                                                                    // update post data on web data
                                                                                                                                    formatedWebsiteData.post    =   postData;

                                                                                                                                    // check if there is related data
                                                                                                                                    const   relatedPostsCondition   =   'SELECT * FROM scontent WHERE cid!=? AND ctype=? AND ccategory=? AND company_id=? ORDER BY cid DESC LIMIT 1000';
                                                                                                                                    const   relatedPostsParameters  =   [""+postUniqueId+"",postType,postCategory,websiteCompany];
                                                                                                                                            //
                                                                                                                                    const   relatedPostsPromise     =   dba.getDataPrepared(relatedPostsCondition,relatedPostsParameters);
                                                                                                                                            relatedPostsPromise.
                                                                                                                                            then((data)=>{
                                                                                                                                                const   relatedPosts                =   data[0];
                                                                                                                                                        formatedWebsiteData.posts   =   relatedPosts;
                                                                                                                                                //
                                                                                                                                                resolve(formatedWebsiteData);
                                                                                                                                            }).
                                                                                                                                            catch((error)=>{
                                                                                                                                                resolve(formatedWebsiteData);
                                                                                                                                            })
                                                                                                                                }
                                                                                                                                else{ resolve(formatedWebsiteData); }
                                                                                                                        
                                                                                                                    }).
                                                                                                                    catch((error)=>{ reject("there is an error");  }); //(formatedWebsiteData);
                                                                                                }
                                                                                            ).
                                                                                            catch(  (error)=>{   reject(error);  });
                                                                                });

                                                            

                                                            return dataPromise;
                                                };

const   GetWebsitePosts                     =   (postsType,postsCategory)=>{
                                                    const   dataPromise =   new Promise((resolve,reject)=>{
                                                                                    //
                                                                                    // fiirst get all site data

                                                                                    

                                                                                    const   formatedWebsiteDataPromise  =   prepareDefaultWebsiteData();
                                                                                            formatedWebsiteDataPromise.
                                                                                            then(
                                                                                                (data)=>{
                                                                        
                                                                                                    //
                                                                                                    var     formatedWebsiteData         =   data;
                                                                                                            formatedWebsiteData.posts   =   new Array();   
                                                                                                    var     postsCondition              =   "SELECT * FROM scontent WHERE ctype=? AND ccategory=? AND company_id=? ORDER BY cid DESC LIMIT 10000";
                                                                                                    var     postsParameters             =   [postsType,postsCategory,websiteCompany];


                                                                                                            //
                                                                                                            // update data fetch condition basing ot special posts category
                                                                                                            switch(postsCategory){
                                                                                                                case "all":
                                                                                                                                            postsCondition      =   "SELECT * FROM scontent WHERE ctype=? AND company_id=? ORDER BY cid DESC LIMIT 10000";
                                                                                                                                            postsParameters     =   [postsType,websiteCompany];
                                                                                                                                            break;
                                                                                                            }

                                                                                                            //
                                                                                                            // update data fetch condition basing ot special posts type
                                                                                                            switch(postsType){
                                                                                                                case "blog":
                                                                                                                                            //
                                                                                                                                            postsCondition      =   "SELECT * FROM scontent WHERE (ctype=? OR (ctype=? AND ccategory=?)) AND company_id=? ORDER BY cid DESC LIMIT 10000";
                                                                                                                                            postsParameters     =   ["articles","about","tips",websiteCompany];
                                                                                                                                            break;

                                                                                                                case "gallery":
                                                                                                                                            postsCondition      =   websiteGalleryCondition;
                                                                                                                                            postsParameters     =   websiteGalleryParameters;
                                                                                                                                            break;

                                                                                                                case "route itineraries":
                                                                                                                                            postsCondition      =   "SELECT * FROM scontent WHERE ctype=? AND ctitle LIKE ? AND company_id=? ORDER BY cid DESC LIMIT 10000";
                                                                                                                                            postsParameters     =   ['itineraries','%'+postsCategory+'%',websiteCompany];
                                                                                                                                            break;
                                                                                                            }
                                                                                                            
                                                                                                            const   postsDataPromise     =   dba.getDataPrepared(postsCondition,postsParameters);
                                                                                                                    postsDataPromise.
                                                                                                                    then((data)=>{

                                                                                                                        const   targetedDataRows            =   data[0];
                                                                                                                                formatedWebsiteData.posts   =   targetedDataRows;

                                                                                                                                // resolve updated website data
                                                                                                                                resolve(formatedWebsiteData);
                                                                                                                    }).
                                                                                                                    catch((error)=>{    resolve(formatedWebsiteData);   });
                                                                                                }
                                                                                            ).
                                                                                            catch(  (error)=>{   reject("unknown data error - V1");  });
                                                                            });

                                                            

                                                            return dataPromise;
                                                };

const   GetWebsitePostsBySql                =   (postsCondition,postsParameters)=>{
                                                    const   dataPromise =   new Promise((resolve,reject)=>{
                                                                                    //
                                                                                    // fiirst get all site data

                                                                                    

                                                                                    const   formatedWebsiteDataPromise  =   prepareDefaultWebsiteData();
                                                                                            formatedWebsiteDataPromise.
                                                                                            then(
                                                                                                (data)=>{
                                                                        
                                                                                                    //
                                                                                                    var     formatedWebsiteData         =   data;
                                                                                                            formatedWebsiteData.posts   =   new Array();   
                                                                                                            
                                                                                                            const   postsDataPromise     =   dba.getDataPrepared(postsCondition,postsParameters);
                                                                                                                    postsDataPromise.
                                                                                                                    then((data)=>{

                                                                                                                        const   targetedDataRows            =   data[0];
                                                                                                                                formatedWebsiteData.posts   =   targetedDataRows;

                                                                                                                                // resolve updated website data
                                                                                                                                resolve(formatedWebsiteData);
                                                                                                                    }).
                                                                                                                    catch((error)=>{    resolve(formatedWebsiteData);   });
                                                                                                }
                                                                                            ).
                                                                                            catch(  (error)=>{   reject("unknown data error - V1");  });
                                                                            });

                                                            

                                                            return dataPromise;
                                                };

const   updatePostViews                     =   (postId)=>{
                                                    //
                                                    var     postUpdateCondition     =   "UPDATE scontent SET cviews=cviews+1 WHERE cid=? AND company_id=?";
                                                    var     postUpdateParameters    =   [postId,websiteCompany];

                                                    const   postUpdatePromise     =   dba.processDataPrepared(postUpdateCondition,postUpdateParameters);
                                                            postUpdatePromise.
                                                            then((data)=>{
                                                                //   
                                                            }).
                                                            catch((error)=>{
                                                                //

                                                            });
                                                            //
                                                            // return postUpdatePromise;
                                                                    
                                                }

const   SaveAndGetWebsiteData               =   (form_content_type,form_content)=>{
                                                    const   dataPromise =   new Promise((resolve,reject)=>{
                                                                                    //
                                                                                    // first get all site data
                                                                                    const   formatedWebsiteDataPromise  =   prepareDefaultWebsiteData();
                                                                                            formatedWebsiteDataPromise.
                                                                                            then((data)=>{
                                                                                                    var     formatedWebsiteData                     =   data;
                                                                                                    const   googleRecaptchVerificationParameters    =   {
                                                                                                                                                            "secret"    :   googleRecaptchaSecret,
                                                                                                                                                            "response"  :   form_content["google-recaptcha-token"]
                                                                                                                                                        };

                                                                                                    const   googleRecaptchVerificationPromise       =   axios.post(
                                                                                                                                                            'https://www.google.com/recaptcha/api/siteverify?secret='+googleRecaptchaSecret+'&&response='+form_content["google-recaptcha-token"],
                                                                                                                                                            googleRecaptchVerificationParameters,
                                                                                                                                                            {
                                                                                                                                                                header  :   {
                                                                                                                                                                                'Content-Type': 'application/json'
                                                                                                                                                                            }
                                                                                                                                                            }
                                                                                                                                                        );
                                                                                                            googleRecaptchVerificationPromise.
                                                                                                            then(async (response)=>{
                                                                                                                const   googleRecaptchVerificationResponse  =   response.data;
                                                                                                                        //
                                                                                                                        if(!googleRecaptchVerificationResponse.hasOwnProperty("error-codes")){
                                                                                                                            const   googleRecaptchVerificationResponseScore     =   googleRecaptchVerificationResponse["score"]*1;
                                                                                                                                    //
                                                                                                                                    if(googleRecaptchVerificationResponseScore>=0.3){
                                                                                                                                        var     userFullname,userEmail,emailMessage,emailMessageDetails,emailMessageSubject;
                                                                                                                                                //
                                                                                                                                                for(const key in form_content){
                                                                                                                                                    switch(key){
                                                                                                                                                        case "google-recaptcha-token":
                                                                                                                                                                                            //
                                                                                                                                                                                            break;

                                                                                                                                                        default:
                                                                                                                                                                                            var     formInputTitle          =   key.replace(/\-/g,' ');
                                                                                                                                                                                            var     formInputTitleArray     =   formInputTitle.split('');
                                                                                                                                                                                                    formInputTitleArray[0]  =   formInputTitleArray[0].toUpperCase();
                                                                                                                                                                                            const   formInputTitleSentence  =   formInputTitleArray.join('');
                                                                                                                                                                                            var     formInputValue          =   form_content[key];
                                                                                                                                                                                                    //
                                                                                                                                                                                                    emailMessageDetails    +=   '<div style="width:100%;padding:0% 0% 0% 0%;margin:0% 0% 2% 0%;">'+
                                                                                                                                                                                                                                    '<div style="width:27%;padding:0% 0% 0% 0%;margin:0% 2% 0% 0%;font-weight:bold;display:inline-block;vertical-align:middle;"> '+formInputTitleSentence+' </div>'+
                                                                                                                                                                                                                                    '<div style="width:70%;padding:0% 0% 0% 0%;margin:0% 0% 0% 0%;display:inline-block;vertical-align:middle;">'+formInputValue+'</div>'+
                                                                                                                                                                                                                                '</div>';
                                                                                                                                                                                            break;

                                                                                                                                                    }
                                                                                                                                                    /*if(key!="google-recaptcha-token"){

                                                                                                                                                        var     formInputTitle          =   key.replace(/\-/g,' ');
                                                                                                                                                        var     formInputTitleArray     =   formInputTitle.split('');
                                                                                                                                                                formInputTitleArray[0]  =   formInputTitleArray[0].toUpperCase();
                                                                                                                                                        const   formInputTitleSentence  =   formInputTitleArray.join('');
                                                                                                                                                        var     formInputValue          =   form_content[key];
                                                                                                                                                                //
                                                                                                                                                                emailMessageDetails    +=   '<div style="width:100%;padding:0% 0% 0% 0%;margin:0% 0% 2% 0%;">'+
                                                                                                                                                                                                '<div style="width:27%;padding:0% 0% 0% 0%;margin:0% 2% 0% 0%;font-weight:bold;display:inline-block;vertical-align:middle;"> '+formInputTitleSentence+' </div>'+
                                                                                                                                                                                                '<div style="width:70%;padding:0% 0% 0% 0%;margin:0% 0% 0% 0%;display:inline-block;vertical-align:middle;">'+formInputValue+'</div>'+
                                                                                                                                                                                            '</div>';
                                                                                                                                                    }*/
                                                                                                                                                }

                                                                                                                                                //
                                                                                                                                                // prepare emails details basing on form type
                                                                                                                                                switch(form_content_type){
                                                                                                                                                    case "bookings": 
                                                                                                                                                                                        emailMessage            =   '';
                                                                                                                                                                                        userFullname            =   form_content["user-first-name"]+' '+form_content["user-last-name"];
                                                                                                                                                                                        userEmail               =   form_content["user-email"];
                                                                                                                                                                                var     bookingReferenceId      =   '';

                                                                                                                                                                                const   saveBookingCondition    =   "INSERT INTO scontent(ctype,ctitle,ccontent,cdata1,cdata2,company_id) VALUES(?,?,?,?,?,?)";
                                                                                                                                                                                const   saveBookingParameters   =   ['bookings',userFullname,JSON.stringify(form_content),userEmail,form_content['user-mobile'],websiteCompany];
                                                                                                                                                                                
                                                                                                                                                                                const   saveBookingPromise      =   dba.processDataPrepared(saveBookingCondition,saveBookingParameters);  
                                                                                                                                                                                        await saveBookingPromise.
                                                                                                                                                                                        then(
                                                                                                                                                                                            (data)=>{ 
                                                                                                                                                                                                if(data[0].insertId){   bookingReferenceId     =   '#SD-AFRICANGOLDEN-'+data[0].insertId;     }
                                                                                                                                                                                                else{                bookingReferenceId     =   '#error';                       }
                                                                                                                                                                                            }
                                                                                                                                                                                        ).
                                                                                                                                                                                        catch(
                                                                                                                                                                                            (error)=>{  
                                                                                                                                                                                                bookingReferenceId     =   '#error';
                                                                                                                                                                                            }
                                                                                                                                                                                        );                                                                                                                                                                                                                 

                                                                                                                                                                                        emailMessageSubject     =   'Booking Confirmation '+userFullname+' '+bookingReferenceId;
                                                                                                                                                                                        //
                                                                                                                                                                                        // admin email
                                                                                                                                                                                        emailMessage    =   '<div style="width:100%;padding:0% 0% 0% 0%;margin:0% 0% 2% 0%;">'+
                                                                                                                                                                                                                'Dear African Golden Trips Safaris admin, you have received new booking from '+userFullname+' with booking id <b>'+bookingReferenceId+'</b>'+
                                                                                                                                                                                                                '<br>Customer Booking details are as follows'+
                                                                                                                                                                                                            '</div>'+emailMessageDetails;

                                                                                                                                                                                        //
                                                                                                                                                                                        mailer.sendEmail('info@goldentrips.co.tz',emailMessageSubject,emailMessage);

                                                                                                                                                                                        //
                                                                                                                                                                                        // user email
                                                                                                                                                                                        emailMessage    =   '<div style="width:100%;padding:0% 0% 0% 0%;margin:0% 0% 2% 0%;">'+
                                                                                                                                                                                                                'Dear '+userFullname+',Thank you for booking with African Golden Trips Safaris, Our representative will get back to you as soon as posible for further arragements.<br>African Golden Trips Safaris<br>Sakina, white rose Road - Arusha, Tanzania'+
                                                                                                                                                                                                                '<br>Your booking id is <b>'+bookingReferenceId+'</b> and your details are as follows'+
                                                                                                                                                                                                            '</div>'+emailMessageDetails
                                                                                                                                                                                                            '<div style="width:100%;padding:0% 0% 0% 0%;margin:2% 0% 0% 0%;font-weight:bold;align-text:center;">'+
                                                                                                                                                                                                                'Manage your bookings at africangoldentrips.com/bookings/manage'+
                                                                                                                                                                                                            '</div>';
                                                                                                                                                                                        // send email to user
                                                                                                                                                                                        mailer.sendEmail(userEmail,emailMessageSubject,emailMessage);

                                                                                                                                                                                        //
                                                                                                                                                                                        formatedWebsiteData.page_success_message        =   'Dear '+userFullname+',Thank you for booking with African Golden Trips Safaris, Our representative will get back to you as soon as posible for further arragements. Your booking id is <b>'+bookingReferenceId+'</b>';
                                                                                                                                                                                        formatedWebsiteData.page_previous_page          =   '/bookings';
                                                                                                                                                                                        formatedWebsiteData.page_previous_page_title    =   'Bookings';
                                                                                                                                                                                break;

                                                                                                                                                    case "subscriber":
                                                                                                                                                                                userEmail               =   form_content["subscriber-email"];
                                                                                                                                                                                //userFullname            =   form_content["subscriber-name"];
                                                                                                                                                                                userFullname            =   userEmail.split('@')[0];
                                                                                                                                                                                
                                                                                                                                                                                emailMessageSubject     =   'African Golden Trips Safaris website subscriber';
                                                                                                                                                                                //
                                                                                                                                                                                // admin email
                                                                                                                                                                                emailMessage    =   '<div style="width:100%;padding:0% 0% 0% 0%;margin:0% 0% 2% 0%;">'+
                                                                                                                                                                                                        'Dear African Golden Trips Safaris admin, you have new subscriber'+
                                                                                                                                                                                                        '<br>Subscriber\'s details are as follows'+
                                                                                                                                                                                                    '</div>'+emailMessageDetails;
                                                                                                                                                                                //
                                                                                                                                                                                // send email to admin 8t!_L;*T@R8O 
                                                                                                                                                                                mailer.sendEmail('info@goldentrips.co.tz',emailMessageSubject,emailMessage);

                                                                                                                                                                                //
                                                                                                                                                                                // user email
                                                                                                                                                                                emailMessage    =   '<div style="width:100%;padding:0% 0% 0% 0%;margin:0% 0% 2% 0%;">'+
                                                                                                                                                                                                        'Dear '+userFullname+',Thank you for subscribing to our mailing list. Get ready to receive amazing updates,tips and other useful information from us'+
                                                                                                                                                                                                        '<br>Your subscription details are as follows'+
                                                                                                                                                                                                    '</div>'+emailMessageDetails;
                                                                                                                                                                                // send email to user
                                                                                                                                                                                mailer.sendEmail(userEmail,emailMessageSubject,emailMessage);

                                                                                                                                                                                //
                                                                                                                                                                                formatedWebsiteData.page_success_message        =   'Dear '+userFullname+',Thank you for subscribing to our mailing list. Get ready to receive amazing updates,tips and other useful information from us';
                                                                                                                                                                                formatedWebsiteData.page_previous_page          =   '/contact';
                                                                                                                                                                                formatedWebsiteData.page_previous_page_title    =   'Contact us';
                                                                                                                                                                                break;

                                                                                                                                                    case "contact":
                                                                                                                                                                                emailMessage            =   '';
                                                                                                                                                                                userFullname            =   form_content["user-full-name"];
                                                                                                                                                                                userEmail               =   form_content["user-email"];
                                                                                                                                                                                emailMessageSubject     =   'African Golden Trips Safaris website visitor message';
                                                                                                                                                                                //
                                                                                                                                                                                // admin email
                                                                                                                                                                                emailMessage    =   '<div style="width:100%;padding:0% 0% 0% 0%;margin:0% 0% 2% 0%;">'+
                                                                                                                                                                                                        'Dear African Golden Trips Safaris admin, you have received new message from '+userFullname+' (website visitor).'+
                                                                                                                                                                                                        '<br>User message details are as follows'+
                                                                                                                                                                                                    '</div>'+emailMessageDetails;



                                                                                                                                                                                // send email to admin 8t!_L;*T@R8O 
                                                                                                                                                                                mailer.sendEmail('info@goldentrips.co.tz',emailMessageSubject,emailMessage);

                                                                                                                                                                                //
                                                                                                                                                                                // user email
                                                                                                                                                                                emailMessage    =   '<div style="width:100%;padding:0% 0% 0% 0%;margin:0% 0% 2% 0%;">'+
                                                                                                                                                                                                        'Dear '+userFullname+',Thank you for reaching us, Our representative will get back to you as soon as posible.<br>African Golden Trips Safaris<br>Sakina, white rose Road - Arusha, Tanzania'+
                                                                                                                                                                                                        '<br>Your message details are as follows'+
                                                                                                                                                                                                    '</div>'+emailMessageDetails;
                                                                                                                                                                                // send email to user
                                                                                                                                                                                mailer.sendEmail(userEmail,emailMessageSubject,emailMessage);

                                                                                                                                                                                //
                                                                                                                                                                                formatedWebsiteData.page_success_message        =   'Dear '+userFullname+',Thank you for reaching us, Our representative will get back to you as soon as posible.';
                                                                                                                                                                                formatedWebsiteData.page_previous_page          =   '/contact';
                                                                                                                                                                                formatedWebsiteData.page_previous_page_title    =   'Contact us';
                                                                                                                                                                                break;
                                                                                                                                                }
                                                                                                                                                //

                                                                                                                                                //
                                                                                                                                                // resolve data or handle other things
                                                                                                                                                switch(form_content_type){
                                                                                                                                                    case "subscriber":
                                                                                                                                                                            const   saveSubscriberCondition     =   "INSERT INTO scontent(ctype,ccategory,cdata1,cdata2,company_id) VALUES(?,?,?,?,?)";
                                                                                                                                                                            const   saveSubscriberParameters    =   ['subscriber','self',userFullname,userEmail,websiteCompany];
                                                                                                                                                                            const   saveSubscriberPromise       =   dba.processDataPrepared(saveSubscriberCondition,saveSubscriberParameters);
                                                                                                                                                                                    saveSubscriberPromise.
                                                                                                                                                                                    then(
                                                                                                                                                                                        (data)=>{   resolve(formatedWebsiteData);   }
                                                                                                                                                                                    ).
                                                                                                                                                                                    catch(
                                                                                                                                                                                        (error)=>{  resolve(formatedWebsiteData);   }
                                                                                                                                                                                    );
                                                                                                                                                                            break;

                                                                                                                                                    default:
                                                                                                                                                                            resolve(formatedWebsiteData);
                                                                                                                                                                            break;
                                                                                                                                                }
                                                                                                                                    }
                                                                                                                                    else{
                                                                                                                                        //formatedWebsiteData.page_success_message    =   "";
                                                                                                                                        formatedWebsiteData.page_error_message    =   "We can not verify your browser security";
                                                                                                                                        resolve(formatedWebsiteData);
                                                                                                                                    }
                                                                                                                        }
                                                                                                                        else{
                                                                                                                            formatedWebsiteData.page_error_message    =   googleRecaptchVerificationResponse["error-codes"][0];
                                                                                                                            resolve(formatedWebsiteData);
                                                                                                                        }
                                                                                                                        
                                                                                                            }).
                                                                                                            catch((error)=>{
                                                                                                                reject(error);
                                                                                                            });

                                                                                            }).
                                                                                            catch((error)=>{ reject(error);});
                                                                            });

                                                            return dataPromise;
                                                };

const   FilterWebsiteData                   =   (rows)=>{

                                                    var websiteData     =   {
                                                                                categories                  :   {},
                                                                                main_about                  :   "none",
                                                                                other_abouts                :   {},
                                                                                vision                      :   "none",
                                                                                mission                     :   "none",
                                                                                post                        :   "none",
                                                                                posts                       :   new Array(),
                                                                                most_viewed                 :   new Array(),
                                                                                members                     :   new Array(),
                                                                                events                      :   new Array(),
                                                                                testimonial                 :   new Array(),
                                                                                slides                      :   new Array(),
                                                                                pictures                    :   new Array(),
                                                                                gallery                     :   new Array(),
                                                                                videos                      :   new Array(),
                                                                                events                      :   new Array(),
                                                                                destinations                :   new Array(),
                                                                                itineraries                 :   new Array(),
                                                                                articles                    :   new Array(),
                                                                                materials                   :   new Array(),
                                                                                team                        :   new Array(),
                                                                                reviews                     :   new Array(),
                                                                                others                      :   {},
                                                                                ads                         :   {
                                                                                                                    top     :   new Array(),
                                                                                                                    side    :   new Array(),
                                                                                                                },
                                                                                contacts                    :   {
                                                                                                                    mobiles     :   new Array(),
                                                                                                                    emails      :   new Array(),
                                                                                                                    postals     :   new Array(),
                                                                                                                    physicals   :   new Array()
                                                                                                                },
                                                                                links                       :   websiteLinks,
                                                                                websiteCompany              :   websiteCompany,
                                                                                googleRecaptchaKey          :   googleRecaptchaKey,
                                                                                people_counters             :   [1,2,3,4,5,6,7,8,9,10,"More than 10"],
                                                                                countries                   :   {'TZ':'Tanzania', 'KE':'Kenya', 'AF':'Afghanistan', 'AX':'Aland Islands', 'AL':'Albania', 'DZ':'Algeria', 'AS':'American Samoa', 'AD':'Andorra', 'AO':'Angola', 'AI':'Anguilla', 'AQ':'Antarctica', 'AG':'Antigua And Barbuda', 'AR':'Argentina', 'AM':'Armenia', 'AW':'Aruba', 'AU':'Australia', 'AT':'Austria', 'AZ':'Azerbaijan', 'BS':'Bahamas', 'BH':'Bahrain', 'BD':'Bangladesh', 'BB':'Barbados', 'BY':'Belarus', 'BE':'Belgium', 'BZ':'Belize', 'BJ':'Benin', 'BM':'Bermuda', 'BT':'Bhutan', 'BO':'Bolivia', 'BA':'Bosnia And Herzegovina', 'BW':'Botswana', 'BV':'Bouvet Island', 'BR':'Brazil', 'IO':'British Indian Ocean Territory', 'BN':'Brunei Darussalam', 'BG':'Bulgaria', 'BF':'Burkina Faso', 'BI':'Burundi', 'KH':'Cambodia', 'CM':'Cameroon', 'CA':'Canada', 'CV':'Cape Verde', 'KY':'Cayman Islands', 'CF':'Central African Republic', 'TD':'Chad', 'CL':'Chile', 'CN':'China', 'CX':'Christmas Island', 'CC':'Cocos (Keeling) Islands', 'CO':'Colombia', 'KM':'Comoros', 'CG':'Congo', 'CD':'Congo, Democratic Republic', 'CK':'Cook Islands', 'CR':'Costa Rica', 'CI':'Cote D\'Ivoire', 'HR':'Croatia', 'CU':'Cuba', 'CY':'Cyprus', 'CZ':'Czech Republic', 'DK':'Denmark', 'DJ':'Djibouti', 'DM':'Dominica', 'DO':'Dominican Republic', 'EC':'Ecuador', 'EG':'Egypt', 'SV':'El Salvador', 'GQ':'Equatorial Guinea', 'ER':'Eritrea', 'EE':'Estonia', 'ET':'Ethiopia', 'FK':'Falkland Islands (Malvinas)', 'FO':'Faroe Islands', 'FJ':'Fiji', 'FI':'Finland', 'FR':'France', 'GF':'French Guiana', 'PF':'French Polynesia', 'TF':'French Southern Territories', 'GA':'Gabon', 'GM':'Gambia', 'GE':'Georgia', 'DE':'Germany', 'GH':'Ghana', 'GI':'Gibraltar', 'GR':'Greece', 'GL':'Greenland', 'GD':'Grenada', 'GP':'Guadeloupe', 'GU':'Guam', 'GT':'Guatemala', 'GG':'Guernsey', 'GN':'Guinea', 'GW':'Guinea-Bissau', 'GY':'Guyana', 'HT':'Haiti', 'HM':'Heard Island & Mcdonald Islands', 'VA':'Holy See (Vatican City State)', 'HN':'Honduras', 'HK':'Hong Kong', 'HU':'Hungary', 'IS':'Iceland', 'IN':'India', 'ID':'Indonesia', 'IR':'Iran, Islamic Republic Of', 'IQ':'Iraq', 'IE':'Ireland', 'IM':'Isle Of Man', 'IL':'Israel', 'IT':'Italy', 'JM':'Jamaica', 'JP':'Japan', 'JE':'Jersey', 'JO':'Jordan', 'KZ':'Kazakhstan', 'KI':'Kiribati', 'KR':'Korea', 'KW':'Kuwait', 'KG':'Kyrgyzstan', 'LA':'Lao People\'s Democratic Republic', 'LV':'Latvia', 'LB':'Lebanon', 'LS':'Lesotho', 'LR':'Liberia', 'LY':'Libyan Arab Jamahiriya', 'LI':'Liechtenstein', 'LT':'Lithuania', 'LU':'Luxembourg', 'MO':'Macao', 'MK':'Macedonia', 'MG':'Madagascar', 'MW':'Malawi', 'MY':'Malaysia', 'MV':'Maldives', 'ML':'Mali', 'MT':'Malta', 'MH':'Marshall Islands', 'MQ':'Martinique', 'MR':'Mauritania', 'MU':'Mauritius', 'YT':'Mayotte', 'MX':'Mexico', 'FM':'Micronesia, Federated States Of', 'MD':'Moldova', 'MC':'Monaco', 'MN':'Mongolia', 'ME':'Montenegro', 'MS':'Montserrat', 'MA':'Morocco', 'MZ':'Mozambique', 'MM':'Myanmar', 'NA':'Namibia', 'NR':'Nauru', 'NP':'Nepal', 'NL':'Netherlands', 'AN':'Netherlands Antilles', 'NC':'New Caledonia', 'NZ':'New Zealand', 'NI':'Nicaragua', 'NE':'Niger', 'NG':'Nigeria', 'NU':'Niue', 'NF':'Norfolk Island', 'MP':'Northern Mariana Islands', 'NO':'Norway', 'OM':'Oman', 'PK':'Pakistan', 'PW':'Palau', 'PS':'Palestinian Territory, Occupied', 'PA':'Panama', 'PG':'Papua New Guinea', 'PY':'Paraguay', 'PE':'Peru', 'PH':'Philippines', 'PN':'Pitcairn', 'PL':'Poland', 'PT':'Portugal', 'PR':'Puerto Rico', 'QA':'Qatar', 'RE':'Reunion', 'RO':'Romania', 'RU':'Russian Federation', 'RW':'Rwanda', 'BL':'Saint Barthelemy', 'SH':'Saint Helena', 'KN':'Saint Kitts And Nevis', 'LC':'Saint Lucia', 'MF':'Saint Martin', 'PM':'Saint Pierre And Miquelon', 'VC':'Saint Vincent And Grenadines', 'WS':'Samoa', 'SM':'San Marino', 'ST':'Sao Tome And Principe', 'SA':'Saudi Arabia', 'SN':'Senegal', 'RS':'Serbia', 'SC':'Seychelles', 'SL':'Sierra Leone', 'SG':'Singapore', 'SK':'Slovakia', 'SI':'Slovenia', 'SB':'Solomon Islands', 'SO':'Somalia', 'ZA':'South Africa', 'GS':'South Georgia And Sandwich Isl.', 'ES':'Spain', 'LK':'Sri Lanka', 'SD':'Sudan', 'SR':'Suriname', 'SJ':'Svalbard And Jan Mayen', 'SZ':'Swaziland', 'SE':'Sweden', 'CH':'Switzerland', 'SY':'Syrian Arab Republic', 'TW':'Taiwan', 'TJ':'Tajikistan', 'TH':'Thailand', 'TL':'Timor-Leste', 'TG':'Togo', 'TK':'Tokelau', 'TO':'Tonga', 'TT':'Trinidad And Tobago', 'TN':'Tunisia', 'TR':'Turkey', 'TM':'Turkmenistan', 'TC':'Turks And Caicos Islands', 'TV':'Tuvalu', 'UG':'Uganda', 'UA':'Ukraine', 'AE':'United Arab Emirates', 'GB':'United Kingdom', 'US':'United States', 'UM':'United States Outlying Islands', 'UY':'Uruguay', 'UZ':'Uzbekistan', 'VU':'Vanuatu', 'VE':'Venezuela', 'VN':'Viet Nam', 'VG':'Virgin Islands, British', 'VI':'Virgin Islands, U.S.', 'WF':'Wallis And Futuna', 'EH':'Western Sahara', 'YE':'Yemen', 'ZM':'Zambia', 'ZW':'Zimbabwe'},
                                                                                countries_codes             :   {'255':'Tanzania (+255)', '254':'Kenya (+254)', '44':'United Kingdom (+44)', '1':'United States (+1)', '213':'Algeria (+213)', '376':'Andorra (+376)', '244':'Angola (+244)', '1264':'Anguilla (+1264)', '1268':'Antigua & Barbuda (+1268)', '54':'Argentina (+54)', '374':'Armenia (+374)', '297':'Aruba (+297)', '61':'Australia (+61)', '43':'Austria (+43)', '994':'Azerbaijan (+994)', '1242':'Bahamas (+1242)', '973':'Bahrain (+973)', '880':'Bangladesh (+880)', '1246':'Barbados (+1246)', '375':'Belarus (+375)', '32':'Belgium (+32)', '501':'Belize (+501)', '229':'Benin (+229)', '1441':'Bermuda (+1441)', '975':'Bhutan (+975)', '591':'Bolivia (+591)', '387':'Bosnia Herzegovina (+387)', '267':'Botswana (+267)', '55':'Brazil (+55)', '673':'Brunei (+673)', '359':'Bulgaria (+359)', '226':'Burkina Faso (+226)', '257':'Burundi (+257)', '855':'Cambodia (+855)', '237':'Cameroon (+237)', '1C':'Canada (+1)', '238':'Cape Verde Islands (+238)', '1345':'Cayman Islands (+1345)', '236':'Central African Republic (+236)', '56':'Chile (+56)', '86':'China (+86)', '57':'Colombia (+57)', '269':'Comoros (+269)', '242':'Congo (+242)', '682':'Cook Islands (+682)', '506':'Costa Rica (+506)', '385':'Croatia (+385)', '53':'Cuba (+53)', '90392':'Cyprus North (+90392)', '357':'Cyprus South (+357)', '42':'Czech Republic (+42)', '45':'Denmark (+45)', '253':'Djibouti (+253)', '1809':'Dominica (+1809)', '1809':'Dominican Republic (+1809)', '593':'Ecuador (+593)', '20':'Egypt (+20)', '503':'El Salvador (+503)', '240':'Equatorial Guinea (+240)', '291':'Eritrea (+291)', '372':'Estonia (+372)', '251':'Ethiopia (+251)', '500':'Falkland Islands (+500)', '298':'Faroe Islands (+298)', '679':'Fiji (+679)', '358':'Finland (+358)', '33':'France (+33)', '594':'French Guiana (+594)', '689':'French Polynesia (+689)', '241':'Gabon (+241)', '220':'Gambia (+220)', '7880':'Georgia (+7880)', '49':'Germany (+49)', '233':'Ghana (+233)', '350':'Gibraltar (+350)', '30':'Greece (+30)', '299':'Greenland (+299)', '1473':'Grenada (+1473)', '590':'Guadeloupe (+590)', '671':'Guam (+671)', '502':'Guatemala (+502)', '224':'Guinea (+224)', '245':'Guinea - Bissau (+245)', '592':'Guyana (+592)', '509':'Haiti (+509)', '504':'Honduras (+504)', '852':'Hong Kong (+852)', '36':'Hungary (+36)', '354':'Iceland (+354)', '91':'India (+91)', '62':'Indonesia (+62)', '98':'Iran (+98)', '964':'Iraq (+964)', '353':'Ireland (+353)', '972':'Israel (+972)', '39':'Italy (+39)', '1876':'Jamaica (+1876)', '81':'Japan (+81)', '962':'Jordan (+962)', '7':'Kazakhstan (+7)', '686':'Kiribati (+686)', '850':'Korea North (+850)', '82':'Korea South (+82)', '965':'Kuwait (+965)', '996':'Kyrgyzstan (+996)', '856':'Laos (+856)', '371':'Latvia (+371)', '961':'Lebanon (+961)', '266':'Lesotho (+266)', '231':'Liberia (+231)', '218':'Libya (+218)', '417':'Liechtenstein (+417)', '370':'Lithuania (+370)', '352':'Luxembourg (+352)', '853':'Macao (+853)', '389':'Macedonia (+389)', '261':'Madagascar (+261)', '265':'Malawi (+265)', '60':'Malaysia (+60)', '960':'Maldives (+960)', '223':'Mali (+223)', '356':'Malta (+356)', '692':'Marshall Islands (+692)', '596':'Martinique (+596)', '222':'Mauritania (+222)', '269':'Mayotte (+269)', '52':'Mexico (+52)', '691':'Micronesia (+691)', '373':'Moldova (+373)', '377':'Monaco (+377)', '976':'Mongolia (+976)', '1664':'Montserrat (+1664)', '212':'Morocco (+212)', '258':'Mozambique (+258)', '95':'Myanmar (+95)', '264':'Namibia (+264)', '674':'Nauru (+674)', '977':'Nepal (+977)', '31':'Netherlands (+31)', '687':'New Caledonia (+687)', '64':'New Zealand (+64)', '505':'Nicaragua (+505)', '227':'Niger (+227)', '234':'Nigeria (+234)', '683':'Niue (+683)', '672':'Norfolk Islands (+672)', '670':'Northern Marianas (+670)', '47':'Norway (+47)', '968':'Oman (+968)', '680':'Palau (+680)', '507':'Panama (+507)', '675':'Papua New Guinea (+675)', '595':'Paraguay (+595)', '51':'Peru (+51)', '63':'Philippines (+63)', '48':'Poland (+48)', '351':'Portugal (+351)', '1787':'Puerto Rico (+1787)', '974':'Qatar (+974)', '262':'Reunion (+262)', '40':'Romania (+40)', '7':'Russia (+7)', '250':'Rwanda (+250)', '378':'San Marino (+378)', '239':'Sao Tome & Principe (+239)', '966':'Saudi Arabia (+966)', '221':'Senegal (+221)', '381':'Serbia (+381)', '248':'Seychelles (+248)', '232':'Sierra Leone (+232)', '65':'Singapore (+65)', '421':'Slovak Republic (+421)', '386':'Slovenia (+386)', '677':'Solomon Islands (+677)', '252':'Somalia (+252)', '27':'South Africa (+27)', '34':'Spain (+34)', '94':'Sri Lanka (+94)', '290':'St. Helena (+290)', '1869':'St. Kitts (+1869)', '1758':'St. Lucia (+1758)', '249':'Sudan (+249)', '597':'Suriname (+597)', '268':'Swaziland (+268)', '46':'Sweden (+46)', '41':'Switzerland (+41)', '963':'Syria (+963)', '886':'Taiwan (+886)', '7':'Tajikstan (+7)', '66':'Thailand (+66)', '228':'Togo (+228)', '676':'Tonga (+676)', '1868':'Trinidad & Tobago (+1868)', '216':'Tunisia (+216)', '90':'Turkey (+90)', '7':'Turkmenistan (+7)', '993':'Turkmenistan (+993)', '1649':'Turks & Caicos Islands (+1649)', '688':'Tuvalu (+688)', '256':'Uganda (+256)', '380':'Ukraine (+380)', '971':'United Arab Emirates (+971)', '598':'Uruguay (+598)', '7':'Uzbekistan (+7)', '678':'Vanuatu (+678)', '379':'Vatican City (+379)', '58':'Venezuela (+58)', '84':'Vietnam (+84)', '84':'Virgin Islands - British (+1284)', '84':'Virgin Islands - US (+1340)', '681':'Wallis & Futuna (+681)', '969':'Yemen (North)(+969)', '967':'Yemen (South)(+967)', '260':'Zambia (+260)', '263':'Zimbabwe (+263)'},
                                                                                titleKeywordsToRemove       :   titleKeywordsToRemove,
                                                                                titleKeywordsToCheck        :   titleKeywordsToCheck,
                                                                                page_previous_page          :   "none",
                                                                                page_previous_page_title    :   "none",
                                                                                page_error_message          :   "none",
                                                                                page_success_message        :   "none"
                                                                            };

                                                        for(const i in rows){

                                                            const   rowData             =   rows[i];
                                                            const   rowDataType         =   rowData.ctype;
                                                            const   rowDataCtitle       =   rowData.ctitle;
                                                            const   rowDataCategory     =   rowData.ccategory;
                                                                    //
                                                                    switch(rowDataType){

                                                                        case "categories":
                                                                                                if(websiteData.categories.hasOwnProperty(rowDataCategory)){
                                                                                                    websiteData.categories[rowDataCategory].push(rowData);
                                                                                                }
                                                                                                else{
                                                                                                    websiteData.categories[rowDataCategory] =   new Array();
                                                                                                    websiteData.categories[rowDataCategory].push(rowData);
                                                                                                }
                                                                                                break;
                                                                        
                                                                        case "about":
                                                                                                switch(rowDataCategory){

                                                                                                    case "main_about":
                                                                                                                                websiteData.main_about  =   rowData;
                                                                                                                                break;
                                                                                                    
                                                                                                    case "vision":
                                                                                                                                websiteData.vision      =   rowData;
                                                                                                                                break;
                                                                                                    
                                                                                                    case "mission":
                                                                                                                                websiteData.mission     =   rowData;
                                                                                                                                break;

                                                                                                    default:
                                                                                                                                    websiteData.links   =   checkSublinks(rowData,'ccategory',websiteData.links);

                                                                                                                                    //
                                                                                                                                    // add about to other abouts
                                                                                                                                    if(websiteData.other_abouts[rowDataCategory]){
                                                                                                                                        websiteData.other_abouts[rowDataCategory].push(rowData);
                                                                                                                                    }
                                                                                                                                    else{
                                                                                                                                        websiteData.other_abouts[rowDataCategory]   =   new Array();
                                                                                                                                        websiteData.other_abouts[rowDataCategory].push(rowData);
                                                                                                                                    }
                                                                                                                                break;

                                                                                                }
                                                                                                break;
                                                                        
                                                                        case "contacts":
                                                                                                switch(rowDataCategory){

                                                                                                    case "mobile":
                                                                                                                        websiteData.contacts.mobiles.push(rowData);
                                                                                                                        break;
                                                                                                    
                                                                                                    case "email":
                                                                                                                        websiteData.contacts.emails.push(rowData);
                                                                                                                        break;
                                                                                                    
                                                                                                    case "postal":
                                                                                                                        websiteData.contacts.postals.push(rowData);
                                                                                                                        break;
                                                                                                    case "physical":
                                                                                                                        websiteData.contacts.physicals.push(rowData);
                                                                                                                        break;

                                                                                                }
                                                                                                break;
                                                                        case "team":
                                                                                                websiteData.team.push(rowData);
                                                                                                break;

                                                                        case "destinations":
                                                                                                // add to destinations
                                                                                                
                                                                                                websiteData.destinations.push(rowData);
                                                                                                websiteData.links   =   checkSublinks(rowData,'ctype',websiteData.links);
                                                                                                
                                                                                                // add to gallery
                                                                                                websiteData.gallery.push(rowData);
                                                                                                break;

                                                                                                

                                                                        default:
                                                                                                if(websiteData.hasOwnProperty(rowDataType)){

                                                                                                    switch(rowDataType){
                                                                                                        // pictures posts sort them
                                                                                                        case "pictures":

                                                                                                                            switch(rowDataCategory){
                                                                                                                                // special categories pictures, add them to their categories
                                                                                                                                case "top_ad":
                                                                                                                                                    websiteData.ads.top.push(rowData);
                                                                                                                                                    break;
                                                                                                                                
                                                                                                                                case "side_ad":
                                                                                                                                                    websiteData.ads.side.push(rowData);
                                                                                                                                                    break;

                                                                                                                                case "gallery":
                                                                                                                                                    websiteData.gallery.push(rowData);
                                                                                                                                                    break;

                                                                                                                                // general pictures add them to pictures and posts
                                                                                                                                default:
                                                                                                                                                    // add pictures in a group
                                                                                                                                                    websiteData.pictures.push(rowData);
                                                                                                                                                    websiteData.posts.push(rowData);
                                                                                                                            }
                                                                                                                            break;

                                                                                                        case "slides":
                                                                                                                            // add to gallery
                                                                                                                            websiteData.gallery.push(rowData);
                                                                                                                            // add to gallery too
                                                                                                                            websiteData[rowDataType].push(rowData);
                                                                                                                            break;

                                                                                                        case "itineraries":
                                                                                                                            // add to gallery
                                                                                                                            websiteData.gallery.push(rowData);
                                                                                                                            // add to gallery too
                                                                                                                            websiteData[rowDataType].push(rowData);
                                                                                                                            break;

                                                                                                        // other posts add them to its respective category and all posts
                                                                                                        default:
                                                                                                                            websiteData[rowDataType].push(rowData);
                                                                                                                            websiteData.posts.push(rowData);
                                                                                                                            break;
                                                                                                    }
                                                                                                }
                                                                                                else{
                                                                                                    if(websiteData.others.hasOwnProperty(rowDataType)){
                                                                                                        websiteData.others[rowDataType].push(rowData);
                                                                                                    }
                                                                                                    else{
                                                                                                        websiteData.others[rowDataType]  =   new Array();
                                                                                                        websiteData.others[rowDataType].push(rowData);
                                                                                                    }
                                                                                                }
                                                                    }
                                                        } 

                                                        websiteData.contacts.physicals.reverse();
                                                        return websiteData; 

                                                };

const   checkSublinks                       =   (data,key,links)=>{
                                                    //const   dataKeyTitle            =   data[key];
                                                    const   dataKeyTitle            =   data[key].toLowerCase();
                                                    const   matchedLinkWithSublinks =   menuLinksWithSublinks.filter((link)=>link.title==dataKeyTitle);
                                                            if(matchedLinkWithSublinks.length>0){
                                                                //
                                                                var     menuLink                    =   matchedLinkWithSublinks[0];
                                                                var     menuLinkTitle               =   menuLink.title;
                                                                var     menuLinkSublinkRoot         =   menuLink.root;
                                                                var     menuEbcodedUrlId            =   encodeUrl(dataKeyTitle);
                                                                        //
                                                                        links[menuEbcodedUrlId]     =   processSublinks(menuLinkTitle,menuLinkSublinkRoot,links[menuEbcodedUrlId],data);
                                                            }
                                                            
                                                            return links;
                                                }

const   processSublinks                     =   (linkType,linkRoot,previousSublinks,data)=>{
                                                    //
                                                    const   dataTitle               =   data.ctitle.replace(/\\/g,'');
                                                    const   dataTitleEncoded        =   encodeUrl(dataTitle);
                                                    var     newSublinks             =   previousSublinks;
                                                    const   previousMAtchedLinks    =   previousSublinks.filter((sublink)=>sublink.title==dataTitle);

                                                    var     sublinkLink             =   linkRoot+dataTitleEncoded
                                                    var     sublinkDetails          =   {"link":sublinkLink,"title":dataTitle};
                                                    
                                                    //if(previousMAtchedLinks.length==0){
                                                    if(previousMAtchedLinks.length==0){
                                                        switch(linkType){
                                                            default:
                                                                        newSublinks.push(sublinkDetails);
                                                                        break

                                                        }
                                                    }

                                                    return newSublinks;
                                                }

const   encodeUrl                           =   (text)=>{
                                                    const   charactersToEscape      =   ["\\\s","\\\.","\\\%","\\\/","\\\\","\\\&","\\\*","\\\?","\\\-"];
                                                    const   charactersReplacement   =   ["+","-dot-","-perc-","-fslash-","-bslash-","-amp-","-star-","-qmark-","-"];
                                                    var     encodedText             =   text.trim().toLowerCase();

                                                            for(const c in charactersToEscape){
                                                                const   replacementRegex    =   new RegExp(charactersToEscape[c],'gi');
                                                                        encodedText         =   encodedText.replace(replacementRegex,charactersReplacement[c]);
                                                            }

                                                            return encodedText;
                                                };


const   dencodeUrl                          =   (text)=>{
                                                    const   charactersToEscape      =   [" ",".","%","/","\\","&","*","?","-"];
                                                    const   charactersReplacement   =   ["\\+","-dot-","-perc-","-fslash-","-bslash-","-amp-","-star-","-qmark-","-"];
                                                    var     decodedText             =   text.trim().toLowerCase();

                                                            for(const c in charactersToEscape){
                                                                const   replacementRegex    =   new RegExp(charactersReplacement[c],'gi');
                                                                        decodedText         =   decodedText.replace(replacementRegex,charactersToEscape[c]);
                                                            }

                                                            //
                                                            //
                                                            decodedText.trim();

                                                            return decodedText;
                                                };
                                                
        module.exports                      =   {
                                                    websiteCompany,
                                                    GetWebsiteData,
                                                    GetWebsitePosts,
                                                    GetWebsitePostsBySql,
                                                    GetWebsitePost,
                                                    SaveAndGetWebsiteData,
                                                    encodeUrl,
                                                    dencodeUrl,
                                                    titleKeywordsToRemove,
                                                    titleKeywordsToCheck
                                                }