const   express         =   require("express");
const   axios           =   require("axios");
const   cookieParser    =   require("cookie-parser")   
const   Session         =   require("express-session");
const   less            =   require("./controllers/less");
const   app             =   express();

        app.set("view engine","ejs");
        app.set('view options', { rmWhitespace: true });
        app.use(express.static(__dirname+'/public'))
        app.use(express.urlencoded({extended:true}));
        app.use(cookieParser());
        
        app.listen(3000);

        app.get("/",(req,res)=>{
            const   siteData  =   less.GetWebsiteData();
                    siteData.
                    then(
                        (data)=>{
                            //
                            //res.send('...');
                            res.render("index",{siteData:data});
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });

        app.get("/cms",(req,res)=>{
            res.redirect('https://africangoldentrips.com/cms/index.php');
        });

        app.get("/about",(req,res)=>{

            const   siteData  =   less.GetWebsiteData();
                    siteData.
                    then(
                        (data)=>{
                            //
                            // res.send(data);
                            res.render("about",{siteData:data});
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });

        app.get("/about-us",(req,res)=>{

            const   siteData  =   less.GetWebsiteData();
                    siteData.
                    then(
                        (data)=>{
                            //
                            // res.send(data);
                            res.render("about",{siteData:data});
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
                    
        });

        app.get("/gallery",(req,res)=>{

            const   siteData  =   less.GetWebsitePosts("gallery","gallery");
                    siteData.
                    then(
                        (data)=>{
                            //
                            // res.send(data);
                            res.render(
                                "posts",
                                {
                                    siteData        :   data,
                                    pageTitle       :   "Our gallery",
                                    pageDescription :   "Here is the amazing gallery of pictures we have collected during our safaris.",
                                    pageId          :   "gallery",
                                    pageLink        :   "/gallery"
                                }
                            );
                            
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });

        app.get("/blog",(req,res)=>{
            //
            const   siteData  =   less.GetWebsitePosts("blog","blog");
                    siteData.
                    then(
                        (data)=>{
                            //
                            // res.send(data);
                            res.render(
                                "posts",
                                {
                                    siteData        :   data,
                                    pageTitle       :   "Our blog",
                                    pageDescription :   "Our latest updates, tips, blog and other userful information from us ",
                                    pageId          :   "blog",
                                    pageLink        :   "/blog"
                                }
                            );
                            
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });

        app.get("/bookings",(req,res)=>{

            const   siteData  =   less.GetWebsiteData();
                    siteData.
                    then(
                        (data)=>{
                            //
                            // res.send(data);
                            res.render("bookings",{siteData:data});
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });

        app.get("/manage/:task",(req,res)=>{
            const   task        =   req.params.task;
            const   siteData    =   less.GetWebsiteData();
                    siteData.
                    then(
                        (data)=>{
                            //
                            // res.send(data);
                            // res.render("bookings",{siteData:data});
                            res.render(
                                "manage",
                                {
                                    siteData        :   data,
                                    pageTitle       :   "Manage "+task,
                                    pageDescription :   "Manage your "+task+" using our portal",
                                    pageId          :   "manage",
                                    pageTask        :   task,
                                    pageLink        :   "/manage/task"
                                }
                            );
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });

        app.get("/manage/:task/:dataId",(req,res)=>{
            const   task        =   req.params.task;
            const   dataId      =   req.params.dataId;
            const   siteData    =   less.GetWebsiteData();
                    siteData.
                    then(
                        (data)=>{
                            //
                            // res.send(data);
                            // res.render("bookings",{siteData:data});
                            res.render(
                                "manage",
                                {
                                    siteData        :   data,
                                    pageTitle       :   "Manage "+task,
                                    pageDescription :   "Manage your "+task+" using our portal",
                                    pageId          :   "manage",
                                    pageTask        :   task,
                                    pageLink        :   "/manage/"+task
                                }
                            );
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });

        app.get("/manta",(req,res)=>{

            const   siteData  =   less.GetWebsitePosts("members","all");
                    siteData.
                    then(
                        (data)=>{
                            //
                            //res.send(data);
                            res.render("manta",{siteData:data});
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });

        app.get("/contact",(req,res)=>{

            const   siteData  =   less.GetWebsiteData();
                    siteData.
                    then(
                        (data)=>{
                            //
                            // res.send(data);
                            res.render("contact",{siteData:data});
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });

        app.get("/contact-us",(req,res)=>{

            const   siteData  =   less.GetWebsiteData();
                    siteData.
                    then(
                        (data)=>{
                            //
                            // res.send(data);
                            res.render("contact",{siteData:data});
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
                    
        });

        app.get(["/itineraries","/packages","/safaris"],(req,res)=>{

            const   siteData  =   less.GetWebsiteData();
                    siteData.
                    then(
                        (data)=>{
                            //
                            //res.send(data);
                            //res.render("posts",{siteData:data,pageTitle:"Our itineraries"});
                            res.render(
                                "posts",
                                {
                                    siteData        :   data,
                                    pageTitle       :   "Our itineraries",
                                    pageDescription :   "we have customized our packages to fit your needs and buget.",
                                    pageId          :   "itineraries",
                                    pageLink        :   "/packages"
                                }
                            );
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });

        app.get(["/itineraries/:category","/packages/:category"],(req,res)=>{
            //
            const   titleKeywordsToRemove           =   less.titleKeywordsToRemove;
            const   parameters                      =   req.params;
            const   formGETData                     =   req.query;
            
            var     itinerariesCategoryEncoded      =   parameters.category;
            var     itinerariesCategoryDecoded      =   less.dencodeUrl(itinerariesCategoryEncoded);
            var     itinerariesCategoryPureTitle    =   itinerariesCategoryDecoded.replace(new RegExp(less.titleKeywordsToRemove.join('|'),'gi'),'').trim();
                    /*less.titleKeywordsToRemove.map(
                        (keyword)=>{
                            itinerariesCategoryPureTitle    =   itinerariesCategoryPureTitle
                        }
                    )*/
                    //
                    //
                    for(const i in less.titleKeywordsToCheck){
                        const   keyword         =   less.titleKeywordsToCheck[i];
                        const   keywordRegex    =   new RegExp(keyword,"gi")
                                if(keywordRegex.test(itinerariesCategoryPureTitle)){
                                    itinerariesCategoryPureTitle    =   keyword;
                                    break;
                                }
                    }

                    //
                    //
                    itinerariesCategoryPureTitle    =   itinerariesCategoryPureTitle.trim();

                    //
            var     itinerariesTitle        =   itinerariesCategoryPureTitle;
            var     itinerariesLink         =   '/itineraries/'+itinerariesCategoryEncoded;
            
            //var     postsCondition          =   'SELECT * FROM scontent WHERE ctype=? AND IF(EXISTS (SELECT * FROM scontent WHERE ccategory LIKE ? OR cdata2 LIKE ?),  ccategory LIKE ? OR cdata2 LIKE ?, ccontent LIKE ? OR ctitle LIKE ?) AND company_id=? ORDER BY cid DESC LIMIT 10000';
            //var     postsParameters         =   ['itineraries','%'+itinerariesCategoryPureTitle+'%','%'+itinerariesCategoryPureTitle+'%','%'+itinerariesCategoryPureTitle+'%','%'+itinerariesCategoryPureTitle+'%','%'+itinerariesCategoryPureTitle+'%','%'+itinerariesCategoryPureTitle+'%',less.websiteCompany];

            var     postsCondition          =   'SELECT * FROM scontent WHERE ctype=? AND (ctitle LIKE ? OR cdata2 LIKE ? OR ccategory LIKE ? OR ccontent LIKE ?) AND company_id=? ORDER BY cid DESC LIMIT 10000';//AND IF(EXISTS (SELECT * FROM scontent WHERE ccategory LIKE ? OR cdata2 LIKE ?),  ccategory LIKE ? OR cdata2 LIKE ?, ccontent LIKE ? OR ctitle LIKE ?) AND company_id=? ORDER BY cid DESC LIMIT 10000';
            var     postsParameters         =   ['itineraries','%'+itinerariesCategoryPureTitle+'%','%'+itinerariesCategoryPureTitle+'%','%'+itinerariesCategoryPureTitle+'%','%'+itinerariesCategoryPureTitle+'%',less.websiteCompany];

                    //
                    //

                    //
                    switch(itinerariesCategoryDecoded){
                        case "search":
                                                    const   searchKeyword       =   decodeURIComponent(formGETData.keyword);
                                                            postsCondition      =   'SELECT * FROM scontent WHERE ctype=? AND IF(EXISTS (SELECT * FROM scontent WHERE ccategory LIKE ?),  ccategory LIKE ?, (ctitle LIKE ? OR ccontent LIKE ?) ) AND company_id=? ORDER BY cid DESC LIMIT 10000';
                                                            postsParameters     =   ['itineraries','%'+searchKeyword+'%','%'+searchKeyword+'%','%'+searchKeyword+'%','%'+searchKeyword+'%',less.websiteCompany];

                                                            itinerariesTitle    =   searchKeyword;
                                                            itinerariesLink     =   '/itineraries/search?keyword='+itinerariesCategoryEncoded;
                                                            break;

                        case "beach holidays":
                                                    postsCondition  =   'SELECT * FROM scontent WHERE ctype=? AND (ctitle LIKE ? OR ccategory LIKE ?) AND company_id=? ORDER BY cid DESC LIMIT 10000';
                                                    postsParameters =   ['itineraries','%zanzibar%','%zanzibar%',less.websiteCompany];
                                                    break;
                    }
            
            const   siteData                =   less.GetWebsitePostsBySql(postsCondition,postsParameters);
                    siteData.
                    then(
                        (data)=>{
                            //
                            //
                            res.render(
                                "posts",
                                {
                                    siteData        :   data,
                                    pageTitle       :   'Our '+itinerariesTitle+' itineraries ',
                                    pageTitleClean  :   itinerariesCategoryPureTitle,
                                    pageDescription :   'Our best '+itinerariesCategoryPureTitle+' packages tailored to meet your needs and budget. Get a chance to explore the beauty of tanzania',
                                    pageId          :   'safaris',
                                    pageLink        :   itinerariesLink
                                }
                            );
                            
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });

        app.get(["/safari-categories/:type"],(req,res)=>{
            //
            const   titleKeywordsToRemove           =   less.titleKeywordsToRemove;
            const   parameters                      =   req.params;
            const   formGETData                     =   req.query;
            
            var     safariCategoriesTypeEncoded      =   parameters.type;
            var     safariCategoriesTypeDecoded      =   less.dencodeUrl(safariCategoriesTypeEncoded);
            var     safariCategoriesTypePureTitle    =   safariCategoriesTypeDecoded;
                    //
                    //
                    for(const i in less.titleKeywordsToCheck){
                        const   keyword         =   less.titleKeywordsToCheck[i];
                        const   keywordRegex    =   new RegExp(keyword,"gi")
                                if(keywordRegex.test(safariCategoriesTypePureTitle)){
                                    safariCategoriesTypePureTitle    =   keyword;
                                    break;
                                }
                    }

                    //
                    safariCategoriesTypePureTitle    =   safariCategoriesTypePureTitle.trim();
            
            var     postsCondition          =   'SELECT * FROM scontent WHERE ctype=? AND ccategory LIKE ? AND company_id=? ORDER BY cid DESC LIMIT 10000';
            var     postsParameters         =   ['categories','%'+safariCategoriesTypePureTitle+'%',less.websiteCompany];

                    //
                    //
            
            const   siteData                =   less.GetWebsitePostsBySql(postsCondition,postsParameters);
                    siteData.
                    then(
                        (data)=>{
                            //
                            //
                            res.render(
                                "posts",
                                {
                                    siteData        :   data,
                                    pageTitle       :   safariCategoriesTypePureTitle,
                                    pageTitleClean  :   safariCategoriesTypePureTitle,
                                    pageDescription :   'We have grouped '+safariCategoriesTypePureTitle+' packages into the best categories to make it easy for you to find the perfect package',
                                    pageId          :   'categories',
                                    pageLink        :   '/safari-categories/'+safariCategoriesTypeEncoded
                                }
                            );
                            
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });

        app.get("/routes",(req,res)=>{

            const   siteData  =   less.GetWebsiteData();
                    siteData.
                    then(
                        (data)=>{
                            //
                            //res.send(data);
                            res.render(
                                "posts",
                                {
                                    siteData        :   data,
                                    pageTitle       :   "Hiking Routes",
                                    pageDescription :   "Our routes are tailored to give you best experience during hiking.",
                                    pageId          :   "routes",
                                    pageLink        :   "/routes"
                                }
                            );
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });


        app.get("/post/:title",(req,res)=>{

            const   charactersToEscape      =   [".","%","/","\\\\","&","*","?","'"];
            const   charactersReplacement   =   ["-dot-","-perc-","-fslash-","-bslash-","-amp-","-star-","-qmark-","-squote-"];
            //
            var     postTitle            =   req.params.title;
                    postTitle            =   postTitle.replace(/\+/g,' ');
                    for(const c in charactersReplacement){
                        //
                        const   replacementRegex    =   new RegExp(charactersReplacement[c],'g');
                                postTitle        =   postTitle.replace(replacementRegex,charactersToEscape[c]);
                    }
                    
            //
            const   siteData                =   less.GetWebsitePost(postTitle);
                    siteData.
                    then(
                        (data)=>{
                            //
                            // res.send({"post-title":postTitle});
                            res.render("post",{siteData:data});
                        }
                    ).
                    catch(
                        (error)=>{
                            //res.send(postTitle);
                            res.send(error);
                        }
                    );
        });


        app.get("/about/:title",(req,res)=>{

            const   charactersToEscape      =   [".","%","/","\\\\","&","*","?"];
            const   charactersReplacement   =   ["-dot-","-perc-","-fslash-","-bslash-","-amp-","-star-","-qmark-"];
            //
            var     postTitle            =   req.params.title;
                    postTitle            =   postTitle.replace(/\+/g,' ');
                    for(const c in charactersReplacement){
                        //
                        const   replacementRegex    =   new RegExp(charactersReplacement[c],'g');
                                postTitle        =   postTitle.replace(replacementRegex,charactersToEscape[c]);
                    }
                    
            //
            const   siteData                =   less.GetWebsitePost(postTitle);
                    siteData.
                    then(
                        (data)=>{
                            //
                            // res.send({"post-title":postTitle});
                            res.render("post",{siteData:data});
                        }
                    ).
                    catch(
                        (error)=>{
                            //res.send(postTitle);
                            res.send(error);
                        }
                    );
        });


        app.get("/itinerary/:title",(req,res)=>{

            const   charactersToEscape      =   [".","%","/","\\\\","&","*","?","\\\\-"];
            const   charactersReplacement   =   ["-dot-","-perc-","-fslash-","-bslash-","-amp-","-star-","-qmark-","-"];
            //
            var     articleTitle            =   req.params.title;
                    articleTitle            =   articleTitle.replace(/\+/g,' ');
                    for(const c in charactersReplacement){
                        //
                        const   replacementRegex    =   new RegExp(charactersReplacement[c],'g');
                                articleTitle        =   articleTitle.replace(replacementRegex,charactersToEscape[c]);
                    }

                    articleTitle        =   articleTitle.replace(/\\\\\\\\/g,'\\\\');


                    
            //
            const   siteData                =   less.GetWebsitePost(articleTitle);
                    siteData.
                    then(
                        (data)=>{
                            //
                            //res.send({"post-title":articleTitle,"data":data});
                            res.render("post",{siteData:data});
                        }
                    ).
                    catch(
                        (error)=>{
                            //res.send(articleTitle);
                            res.send(error);
                        }
                    );
        });

        app.get("/trekking",(req,res)=>{
            //
            const   postsCondition  =   'SELECT * FROM scontent WHERE ctype=? AND ccategory LIKE ? AND company_id=? ORDER BY cid DESC LIMIT 10000';
            const   postsParameters =   ['itineraries','%_trekking',less.websiteCompany];
            
            const   siteData        =   less.GetWebsitePostsBySql(postsCondition,postsParameters);
                    siteData.
                    then(
                        (data)=>{
                            //
                            //
                            res.render(
                                "posts",
                                {
                                    siteData        :   data,
                                    pageTitle       :   'Our Trekking Safaris',
                                    pageDescription :   'Our best trekking safari packages tailored to meet your needs and budget. Get a chance to explore the beauty of different mountains and hills in Tanzania',
                                    pageId          :   'trekking',
                                    pageLink        :   '/trekking'
                                }
                            );
                            
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });

        app.get("/trekking/:category",(req,res)=>{

            

            const   trekkingCategory                =   req.params.category;
            const   trekkingCategorytitle           =   trekkingCategory+" trekking";
            const   trekkingCategoryDescription     =   'Here is the amazing list of '+trekkingCategorytitle+' itineraries tailored to meet your needs';
            const   trekkingCategoryLink            =   "/trekking/"+trekkingCategory;
            const   trekkingFullCategory            =   trekkingCategory+"_trekking";
            const   siteData                        =   less.GetWebsitePosts("itineraries",trekkingFullCategory);
                    siteData.
                    then(
                        (data)=>{
                            //
                            // res.send(data);
                            res.render(
                                "posts",
                                {
                                    siteData        :   data,
                                    pageTitle       :   trekkingCategorytitle,
                                    pageDescription :   trekkingCategoryDescription,
                                    pageId          :   "trekking",
                                    pageLink        :   trekkingCategoryLink
                                }
                            );
                            
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });

        app.get("/safaris",(req,res)=>{
            //
            const   postsCondition  =   'SELECT * FROM scontent WHERE ctype=? AND (ccategory=? OR ccategory LIKE ?) AND company_id=? ORDER BY cid DESC LIMIT 10000';
            const   postsParameters =   ['itineraries','safari','%_trip',less.websiteCompany];
            
            const   siteData        =   less.GetWebsitePostsBySql(postsCondition,postsParameters);
                    siteData.
                    then(
                        (data)=>{
                            //
                            //
                            res.render(
                                "posts",
                                {
                                    siteData        :   data,
                                    pageTitle       :   'Our Safaris',
                                    pageDescription :   'Our best safari packages tailored to meet your needs and budget. Get a chance to explore the beauty of tanzania',
                                    pageId          :   'safaris',
                                    pageLink        :   '/safaris'
                                }
                            );
                            
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });

        app.get("/destinations",(req,res)=>{
            //
            const   siteData        =   less.GetWebsiteData();
                    siteData.
                    then(
                        (data)=>{
                            //
                            //
                            res.render(
                                "posts",
                                {
                                    siteData        :   data,
                                    pageTitle       :   'Our destinations',
                                    pageDescription :   'Our best safaris destinations picked to make your safari experience unique and amazing one. Get a chance to explore the beauty of Tanzania with our best destinations',
                                    pageId          :   'destinations',
                                    pageLink        :   '/destinations'
                                }
                            );
                            
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });

        app.get("/activities",(req,res)=>{
            //
            const   postsCondition  =   'SELECT * FROM scontent WHERE ctype=? AND company_id=? ORDER BY cid DESC LIMIT 10000';
            const   postsParameters =   ['activities',less.websiteCompany];
            
            const   siteData        =   less.GetWebsitePostsBySql(postsCondition,postsParameters);
                    siteData.
                    then(
                        (data)=>{
                            //
                            //
                            res.render(
                                "posts",
                                {
                                    siteData        :   data,
                                    pageTitle       :   'Our activities',
                                    pageDescription :   'Our best safaris activities to make your safari experience unique and amazing one. Get a chance to explore the beauty of Tanzania with our best safari acttivities.',
                                    pageId          :   'activities',
                                    pageLink        :   '/activities'
                                }
                            );
                            
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });


        app.get("/activity/:category",(req,res)=>{
            //
            const   activityTitle   =   less.dencodeUrl(req.params.category);
            const   siteData        =   less.GetWebsitePost(activityTitle);
                    siteData.
                    then(
                        (data)=>{
                            //
                            //
                            res.render(
                                "post",
                                {
                                    siteData        :   data,
                                    pageTitle       :   'Our activities',
                                    pageDescription :   'Our best safaris activities to make your safari experience unique and amazing one. Get a chance to explore the beauty of Tanzania with our best safari acttivities.',
                                    pageId          :   'activities',
                                    pageLink        :   '/activities'
                                }
                            );
                            
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });

        app.get("/safaris/:category",(req,res)=>{
            //
            const   safarisCategory                 =   req.params.category;
            const   safarisCategoryRaw              =   safarisCategory.replace(/\+/g,' ');
            var     safarisDaysCategoriesRegex      =   new RegExp('[1-9]{1,2}(\\s)+day','ig');
            var     safarisCategoryDaysRegex        =   new RegExp('[1-9]{1,2}','ig');
            var     safarisCategorytitle            =   "none";
            var     safarisFullCategory             =   "none";

            var     safarisCategoryDescription      =   "none";
            var     safarisCategoryLink             =   "none";
            //
            //
            var     siteData                        =   '';
                    //
                    switch(safarisCategory.replace(/\+/g,'_')){
                        case "day_trips":
                                            safarisCategorytitle           =   "day trips";
                                            safarisFullCategory            =   "day_trip";
                                            //
                                            siteData                =   less.GetWebsitePosts("itineraries",safarisFullCategory);

                                            break;
                        default:
                                            // detect if it is days trips get day number
                                            
                                            

                                            if(safarisDaysCategoriesRegex.test(safarisCategoryRaw)){

                                                const   daysFoundInSafariCategory   =   safarisCategoryRaw.match(safarisCategoryDaysRegex);
                                                const   safarisCategoryDays         =   daysFoundInSafariCategory[0];   
                                                        safarisCategorytitle        =   safarisCategoryDays+" day(s) safaris";
                                                
                                                const   postsCondition              =   'SELECT * FROM scontent WHERE ctype=? AND ccategory=? AND ctitle LIKE ? AND company_id=? ORDER BY cid DESC LIMIT 10000';
                                                const   postsParameters             =   ['itineraries','safari','%'+safarisCategoryDays+' day%',less.websiteCompany];

                                                        siteData                    =   less.GetWebsitePostsBySql(postsCondition,postsParameters);
                                            }
                                            else{

                                                safarisCategorytitle    =   safarisCategory.replace(/\+/g,' ')+" safaris";
                                                safarisFullCategory     =   safarisCategory.replace(/\+/g,'_')+"_safari";
                                                //
                                                siteData                =   less.GetWebsitePosts("itineraries",safarisFullCategory);
                                            }
                                            break;
                    }


                    safarisCategoryDescription     =   'Here is the amazing list of '+safarisCategorytitle+' itineraries tailored to meet your needs';
                    safarisCategoryLink            =   "/safaris/"+safarisCategory;

                    siteData.
                    then(
                        (data)=>{
                            //
                            //
                            res.render(
                                "posts",
                                {
                                    siteData        :   data,
                                    pageTitle       :   safarisCategorytitle,
                                    pageDescription :   safarisCategoryDescription,
                                    pageId          :   "safaris",
                                    pageLink        :   safarisCategoryLink
                                }
                            );
                            
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });

        app.get("/destination/:category",(req,res)=>{
            //
            const   destination                 =   req.params.category;
            //const   destinationRaw              =   destination.replace(/\+/g,' ');
            var     destinationRaw              =   less.dencodeUrl(destination);
            var     destinationPureTitle        =   destinationRaw;
                    //
                    for(const i in less.titleKeywordsToCheck){
                        const   keyword         =   less.titleKeywordsToCheck[i];
                        const   keywordRegex    =   new RegExp(keyword,"gi")
                                if(keywordRegex.test(destinationPureTitle)){
                                    destinationPureTitle    =   keyword;
                                    break;
                                }
                    }

                    //
                    //
                    destinationPureTitle        =   destinationPureTitle.trim();

            var     safarisCategorytitle        =   destinationRaw;
            var     safarisCategoryDescription  =   'Here is the amazing list of '+destinationPureTitle+' itineraries tailored to meet your needs';
            var     safarisCategoryLink         =   "/destination/"+destination;
            //
            //

            
            // const   postsCondition              =   'SELECT * FROM scontent WHERE ctype=? AND (ctitle LIKE ? OR ccontent LIKE ?) AND company_id=? ORDER BY cid DESC LIMIT 10000';
            // const   postsCondition              =   'SELECT * FROM scontent WHERE ctype=? AND IF(EXISTS (SELECT * FROM scontent WHERE ccategory LIKE ?),  ccategory LIKE ?, ctitle LIKE ? ) AND company_id=? ORDER BY cid DESC LIMIT 10000';
            // const   postsParameters             =   ['itineraries','%'+destinationPureTitle+'%','%'+destinationPureTitle+'%','%'+destinationPureTitle+'%',less.websiteCompany];

            var     postsCondition              =   'SELECT * FROM scontent WHERE ctype=? AND (ctitle LIKE ? OR cdata2 LIKE ? OR ccategory LIKE ? OR ccontent LIKE ?) AND company_id=? ORDER BY cid DESC LIMIT 10000'; //AND IF(EXISTS (SELECT * FROM scontent WHERE ccategory LIKE ? OR cdata2 LIKE ?),  ccategory LIKE ? OR cdata2 LIKE ?, ccontent LIKE ? OR ctitle LIKE ?) AND company_id=? ORDER BY cid DESC LIMIT 10000';
            var     postsParameters             =   ['itineraries','%'+destinationPureTitle+'%','%'+destinationPureTitle+'%','%'+destinationPureTitle+'%','%'+destinationPureTitle+'%',less.websiteCompany];

            const   siteData                    =   less.GetWebsitePostsBySql(postsCondition,postsParameters);
                    siteData.
                    then(
                        (data)=>{
                            //
                            //
                            res.render(
                                "posts",
                                {
                                    siteData            :   data,
                                    destinationTitle    :   destinationRaw,
                                    pageTitle           :   safarisCategorytitle,
                                    pageTitleClean      :   destinationPureTitle,
                                    pageDescription     :   safarisCategoryDescription,
                                    pageId              :   "destination",
                                    pageLink            :   safarisCategoryLink,
                                }
                            );
                            
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });

        app.get("/route/:name",(req,res)=>{
            //
            const   routeRawName        =   req.params.name;
            const   routeName           =   routeRawName.replace(/\+/g,' ');
            const   routeTitle          =   routeName+' itineraries';
            const   routeLink           =   '/route/'+routeRawName;
            const   routeDescription    =   'Here is the amazing list of '+routeTitle+' tailored to meet your needs and budget';
                   

            const   siteData                        =   less.GetWebsitePosts("route itineraries",routeName);
                    siteData.
                    then(
                        (data)=>{
                            //
                            //
                            res.render(
                                "posts",
                                {
                                    siteData        :   data,
                                    pageTitle       :   routeTitle,
                                    pageDescription :   routeDescription,
                                    pageId          :   "trekking",
                                    pageLink        :   routeLink
                                }
                            );
                            
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });

        //
        app.get("/contact-us-african-africangolden-tanzania",(req,res)=>{

            const   siteData  =   less.GetWebsiteData();
                    siteData.
                    then(
                        (data)=>{
                            //
                            // res.send(data);
                            res.render("contact",{siteData:data});
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
                    
        });

        app.post("/save/:content_type",(req,res)=>{
            //
            const   formContentType     =   req.params.content_type;
            const   formContent         =   req.body;
            
                    //
            const   siteData        =   less.SaveAndGetWebsiteData(formContentType,formContent);
                    siteData.
                    then(
                        (data)=>{
                            var pageToLoad      =   '';
                            var pageFrom        =   '';
                            var pageFromTitle   =   '';
                                //
                                //res.send(data);
                                switch(formContentType){
                                    case "bookings":
                                                        if(data.page_success_message!="none"){
                                                            pageToLoad  =   "status";
                                                        }
                                                        else{
                                                            pageToLoad  =   "bookings";
                                                        }
                                                        //
                                                        //
                                                        pageFrom        =   '/bookings';
                                                        pageFromTitle   =   'Bookings';
                                                        break;

                                    case "contact":
                                                        if(data.page_success_message!="none"){
                                                            pageToLoad  =   "status";
                                                        }
                                                        else{
                                                            pageToLoad  =   "contact";
                                                        }
                                                        //
                                                        //
                                                        pageFrom        =   '/contact-us';
                                                        pageFromTitle   =   'Conctact us';
                                                        break;

                                    case "subscriber":
                                                        if(data.page_success_message!="none"){
                                                            pageToLoad  =   "status";
                                                        }
                                                        else{
                                                            pageToLoad  =   "contact";
                                                        }
                                                        //
                                                        //
                                                        pageFrom        =   '/contact-us';
                                                        pageFromTitle   =   'Conctact us';
                                                        break;

                                    default:
                                                        pageFrom        =   '/contact-us';
                                                        pageFromTitle   =   'Conctact us';
                                                        pageToLoad      =   "contact";
                                                        break;

                                }

                                //res.send(data);
                                res.render(
                                            pageToLoad,
                                            {

                                                pageFrom        :   pageFrom,
                                                pageFromTitle   :   pageFromTitle,
                                                siteData        :   data
                                            });
                            
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });

        app.post("/get/:dataType",(req,res)=>{
            //
            const   formDataType        =   req.params.dataType;
            const   formContent         =   req.body;
            
                    //
            var     postsCondition      =   'SELECT * FROM scontent WHERE ctype=? AND company_id=? ORDER BY cid DESC LIMIT 10000';
            var     postsParameters     =   [formDataType,less.websiteCompany];
                    //
                    switch(formDataType){
                        case "bookings":
                                            postsCondition      =   'SELECT * FROM scontent WHERE ctype=? AND cid=? AND cdata1=? AND company_id=? ORDER BY cid DESC LIMIT 10000';
                                            postsParameters     =   ['bookings',formContent['booking-id'].replace(/[^0-9]/gi,''),formContent['booking-email'],less.websiteCompany];
                    }

            const   siteData            =   less.GetWebsitePostsBySql(postsCondition,postsParameters);
                    siteData.
                    then(
                        (data)=>{
                            var pageToLoad      =   '';
                            var pageToLoadData  =   {};
                            var pageFrom        =   '';
                            var pageFromTitle   =   '';
                                //
                                //res.send(data);
                                switch(formDataType){
                                    case "bookings":
                                                        var     bookingData     =   [];
                                                                if(data.posts.length>0){  bookingData     =   data.posts[0];    }

                                                                pageToLoad      =   "manage";
                                                                pageToLoadData  =   {
                                                                                        siteData        :   data,
                                                                                        bookingData     :   bookingData,
                                                                                        pageTitle       :   "Manage your booking - "+formContent['booking-id'],
                                                                                        pageDescription :   "Manage your booking - "+formContent['booking-id']+" using our portal",
                                                                                        pageId          :   "manage",
                                                                                        pageTask        :   "bookings",
                                                                                        pageLink        :   "/manage/bookings"
                                                                                    };
                                                        break;

                                }   
                                                        
                            res.render(pageToLoad,pageToLoadData);
                        }
                    ).
                    catch(
                        (error)=>{
                            res.send(error);
                        }
                    );
        });
